/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import graphics.ScrollBar;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import util.CountRows;

public class GList
extends Canvas {
    protected String list_title;
    protected int selected_index;
    protected int fontHeight;
    protected int first_displayed_index;
    protected int last_displayed_index;
    protected int displayed_items_count;
    protected boolean first_priority;
    protected CountRows count_rows;
    protected Vector items;
    protected Font font;
    protected int rows_per_screen;
    protected int shift;
    protected int list_width;
    protected int bar_size;
    protected Image background;
    public ScrollBar scroll_bar;
    protected CommandListener cmd;
    protected int background_color = 0xFFFFFF;
    protected int frame_color = -2138794294;
    protected int text_color = 0;

    public void setColors(int background_color, int frame_color, int text_color) {
        this.background_color = background_color;
        this.frame_color = frame_color;
        this.text_color = text_color;
    }

    public void setColors() {
        this.background_color = 0xFFFFFF;
        this.frame_color = -2138794294;
        this.text_color = 0;
    }

    protected void showNotify() {
        this.repaint();
    }

    public void setBackgroundColor(int color) {
        this.background_color = color;
        this.repaint();
    }

    public void setFrameColor(int color) {
        this.frame_color = color;
        this.repaint();
    }

    public void setTextColor(int color) {
        this.text_color = color;
        this.repaint();
    }

    public void setCommandListener(CommandListener cmdls) {
        this.cmd = cmdls;
        super.setCommandListener(cmdls);
    }

    public void removeAllItems() {
        this.items = new Vector();
        this.selected_index = 0;
        this.first_displayed_index = 0;
        this.first_priority = true;
        this.scroll_bar.setParameters(this.items.size(), this.getWidth(), this.getHeight());
        this.repaint();
    }

    public void create(String title, Image back, Font f) {
        this.items = new Vector();
        this.selected_index = 0;
        this.first_displayed_index = 0;
        this.first_priority = true;
        this.font = f;
        this.fontHeight = this.font.getHeight() + 2;
        this.background = back;
        this.scroll_bar = new ScrollBar();
        this.scroll_bar.setParameters(this.items.size(), this.getWidth(), this.getHeight());
        this.bar_size = this.getWidth() / 30 + 1;
        this.list_width = this.getWidth() - 2 * this.bar_size;
        this.count_rows = new CountRows(this.list_width, this.font);
        this.displayed_items_count = this.rows_per_screen = this.getHeight() / this.fontHeight;
        this.shift = this.getHeight() % this.fontHeight / 2;
        this.setColors();
        this.repaint();
    }

    public GList(String title, Image back, Font f) {
        this.create(title, back, f);
    }

    public GList(String title, Image back, int font_size) {
        this.create(title, back, Font.getFont((int)0, (int)1, (int)font_size));
    }

    private int itemBeforee(int index) {
        int i = index;
        int r = 0;
        while (r < this.rows_per_screen) {
            if (--i < -1) {
                i = this.items.size() - 1;
            }
            if (i == -1) {
                ++r;
                continue;
            }
            r += this.count_rows.rows((String)this.items.elementAt(i)).size();
        }
        if (++i >= this.items.size()) {
            i = 0;
        }
        return i;
    }

    private int itemAfter(int index) {
        int i = index;
        int r = 0;
        while (r < this.rows_per_screen) {
            if (++i > this.items.size()) {
                i = 0;
            }
            if (i == this.items.size()) {
                ++r;
                continue;
            }
            r += this.count_rows.rows((String)this.items.elementAt(i)).size();
        }
        if (--i < 0) {
            i = this.items.size() - 1;
        }
        return i;
    }

    public void append(String item) {
        this.items.addElement(item);
        this.scroll_bar.setParameters(this.items.size(), this.getWidth(), this.getHeight());
        this.repaint();
    }

    public void setItem(String s, int num) {
        this.items.setElementAt(s, num);
        this.repaint();
    }

    public void delete(int elNum) {
        this.items.removeElementAt(elNum);
        this.scroll_bar.setParameters(this.items.size(), this.getWidth(), this.getHeight());
        this.repaint();
    }

    public int getSelectedIndex() {
        if (!this.items.isEmpty()) {
            return this.selected_index;
        }
        return -1;
    }

    public int getFirstDisplayedIndex() {
        return this.first_displayed_index;
    }

    public int getLastDisplayedIndex() {
        return this.last_displayed_index;
    }

    public boolean firstPriority() {
        return this.first_priority;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public String getString(int elNum) {
        String str;
        try {
            str = (String)this.items.elementAt(elNum);
        }
        catch (Exception e) {
            str = "";
        }
        return str;
    }

    public Graphics drawSelection(int x, int y, int width, int height, int color, Graphics g) {
        int col = g.getColor();
        g.setColor(color);
        g.fillRect(x, y, width, height);
        g.setColor(col);
        return g;
    }

    protected void keyPressed(int keyCode) {
        int key = this.getGameAction(keyCode);
        switch (key) {
            case 8: {
                this.cmd.commandAction(List.SELECT_COMMAND, (Displayable)this);
                return;
            }
            case 2: {
                if (this.displayed_items_count < this.items.size()) {
                    this.first_priority = true;
                    if (this.selected_index == this.first_displayed_index) {
                        this.first_displayed_index = this.itemBeforee(this.first_displayed_index);
                    }
                }
                if (this.first_displayed_index >= this.items.size()) {
                    this.first_displayed_index = this.items.size() - 1;
                }
                this.selected_index = this.first_displayed_index;
                break;
            }
            case 5: {
                if (this.displayed_items_count < this.items.size()) {
                    this.first_priority = false;
                    if (this.selected_index == this.last_displayed_index) {
                        this.last_displayed_index = this.itemAfter(this.last_displayed_index);
                    }
                }
                if (this.last_displayed_index >= this.items.size()) {
                    this.last_displayed_index = 0;
                }
                this.selected_index = this.last_displayed_index;
                break;
            }
            case 6: {
                if (this.displayed_items_count < this.items.size() && this.last_displayed_index == this.selected_index) {
                    ++this.last_displayed_index;
                    this.first_priority = false;
                    if (this.last_displayed_index > this.items.size() - 1) {
                        this.last_displayed_index = 0;
                    }
                }
                ++this.selected_index;
                if (this.selected_index <= this.items.size() - 1) break;
                this.selected_index = 0;
                break;
            }
            case 1: {
                if (this.displayed_items_count < this.items.size() && this.first_displayed_index == this.selected_index) {
                    this.first_priority = true;
                    --this.first_displayed_index;
                    if (this.first_displayed_index < 0) {
                        this.first_displayed_index = this.items.size() - 1;
                    }
                }
                --this.selected_index;
                if (this.selected_index >= 0) break;
                this.selected_index = this.items.size() - 1;
            }
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.background != null) {
            g.drawImage(this.background, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
        if (!this.items.isEmpty()) {
            String line = "----";
            if (this.items.size() > this.displayed_items_count) {
                this.items.addElement(line);
                this.displayed_items_count = -1;
            } else {
                this.displayed_items_count = 0;
            }
            g.setColor(this.text_color);
            if (this.first_priority) {
                int r = 0;
                int c = this.first_displayed_index;
                while (c < this.first_displayed_index + this.rows_per_screen) {
                    if (c - this.first_displayed_index >= this.items.size()) {
                        --c;
                        break;
                    }
                    Vector item = this.count_rows.rows((String)this.items.elementAt(c % this.items.size()));
                    int h = item.size();
                    if (this.selected_index == c % this.items.size()) {
                        g = this.drawSelection(0, r * this.fontHeight + this.shift, this.getWidth(), h * this.fontHeight, this.frame_color, g);
                    }
                    int vshift = 0;
                    int z = 0;
                    while (z < item.size()) {
                        if (z > 0) {
                            vshift = 3;
                        }
                        g.drawString((String)item.elementAt(z), this.bar_size / 2 + vshift, 1 + r * this.fontHeight + this.shift, 20);
                        if (++r >= this.rows_per_screen) {
                            ++r;
                            break;
                        }
                        ++z;
                    }
                    if (r <= this.rows_per_screen) {
                        ++this.displayed_items_count;
                        if (r == this.rows_per_screen) {
                            break;
                        }
                    } else {
                        --c;
                        break;
                    }
                    ++c;
                }
                this.last_displayed_index = c % this.items.size();
                if (this.last_displayed_index == this.items.size() - 1) {
                    --this.last_displayed_index;
                }
            } else {
                int r = 0;
                int c = this.last_displayed_index;
                while (c >= this.last_displayed_index - this.rows_per_screen) {
                    if (this.last_displayed_index - c >= this.items.size()) {
                        --c;
                        break;
                    }
                    Vector item = this.count_rows.rows((String)this.items.elementAt((c + this.items.size()) % this.items.size()));
                    int h = item.size();
                    if (this.selected_index == (c + this.items.size()) % this.items.size()) {
                        g = this.drawSelection(0, this.getHeight() - 1 - (r + h) * this.fontHeight - this.shift, this.getWidth(), h * this.fontHeight, this.frame_color, g);
                    }
                    r += h;
                    int vshift = 0;
                    int z = 0;
                    while (z < h) {
                        if (z > 0) {
                            vshift = 3;
                        }
                        if (r - z <= this.rows_per_screen) {
                            g.drawString((String)item.elementAt(z), this.bar_size / 2 + vshift, this.getHeight() - (r - z) * this.fontHeight - this.shift, 20);
                        }
                        ++z;
                    }
                    if (r <= this.rows_per_screen) {
                        ++this.displayed_items_count;
                        if (r == this.rows_per_screen) {
                            break;
                        }
                    } else {
                        ++c;
                        break;
                    }
                    --c;
                }
                this.first_displayed_index = (c + this.items.size()) % this.items.size();
            }
            if (this.items.size() >= this.displayed_items_count) {
                this.items.removeElement(line);
            }
        }
        if (this.items.size() > 0) {
            this.scroll_bar.paint(this.selected_index, g);
        }
    }

    public void setSelectedIndex(int index) {
        this.selected_index = index;
    }

    public void setFirstDisplayedIndex(int index) {
        this.first_displayed_index = index;
    }

    public void setLastDisplayedIndex(int index) {
        this.last_displayed_index = index;
    }

    public void setFirstPriority(boolean priority) {
        this.first_priority = priority;
    }
}

