/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GaugeScreen
extends Canvas {
    private int value;
    private int max_value;
    private CommandListener cmdls;
    private String title;
    private Image background;
    private Command confirm_command;
    private Font font;
    private String s1;
    private String s2;
    private int col1;
    private int col2;

    public GaugeScreen(Image back, Command cfcm) {
        this.confirm_command = cfcm;
        this.background = back;
        this.title = "";
        this.s1 = "";
        this.s2 = "";
        this.value = 0;
        this.max_value = 1;
        this.col1 = 0;
        this.col2 = 4941225;
        this.font = Font.getFont((int)0, (int)1, (int)0);
    }

    protected void showNotify() {
        this.repaint();
    }

    public void setCommandListener(CommandListener cmd) {
        this.cmdls = cmd;
        super.setCommandListener(cmd);
    }

    public void setValue(int v) {
        this.value = v;
    }

    public void setMaxValue(int v) {
        this.max_value = v;
    }

    public int getValue() {
        return this.value;
    }

    public void setTitle(String ti) {
        this.title = ti;
    }

    protected void keyPressed(int keyCode) {
        int key = this.getGameAction(keyCode);
        switch (key) {
            case 8: {
                this.cmdls.commandAction(this.confirm_command, (Displayable)this);
                return;
            }
            case 2: {
                if (this.value <= 0) break;
                --this.value;
                break;
            }
            case 5: {
                if (this.value >= this.max_value) break;
                ++this.value;
                break;
            }
            case 6: {
                this.value = this.max_value;
                break;
            }
            case 1: {
                this.value = 0;
            }
        }
        this.repaint();
    }

    public void setLegend(String s1, String s2) {
        this.s1 = s1;
        this.s2 = s2;
    }

    public void setColors(int c1, int c2) {
        this.col1 = c1;
        this.col2 = c2;
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.background != null) {
            g.drawImage(this.background, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
        int shift = this.getWidth() / 8;
        g.setColor(0);
        g.setFont(this.font);
        g.drawString(this.title, this.getWidth() / 2, this.getHeight() / 4, 65);
        g.drawString(this.s1, shift, 5 * this.getHeight() / 8 + 2, 20);
        g.drawString(this.s2, this.getWidth() - shift, 5 * this.getHeight() / 8 + 2, 24);
        g.drawString(this.value + "\\" + this.max_value, this.getWidth() / 2, 6 * this.getHeight() / 8, 17);
        int width = 3 * this.getWidth() / 4 / this.max_value;
        int x = this.getWidth() / 2 - this.max_value / 2 * width;
        int height = this.getHeight() / 4 / this.max_value;
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        int p = 1;
        while (p <= this.max_value) {
            if (p > this.value) {
                g.setColor(this.col1);
            } else {
                g.setColor(this.col2);
            }
            int y = height < 1 ? 5 * this.getHeight() / 8 - this.getHeight() * p / 4 / this.max_value : 5 * this.getHeight() / 8 - p * height;
            g.fillRect(x + (p - 1) * width, y, width - 1, 5 * this.getHeight() / 8 - y);
            ++p;
        }
    }
}

