/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import javax.microedition.lcdui.Graphics;

public class ProgressBar {
    private int status;
    private int stat2;
    private int stat3;
    private int status_x;
    private int status_y;
    private int status_width;
    private int status_height;
    private int len;
    private boolean draw;
    private static int border_color = 0x8D8D8D;
    private static int rect_color = 0;
    private static int fill_color = 0xCDCDCD;

    public ProgressBar(int status_x, int status_y, int status_width, int status_height) {
        this.status_x = status_x;
        this.status_y = status_y;
        this.status_width = status_width;
        this.status_height = status_height;
        this.draw = false;
        this.reset();
    }

    public void reset() {
        this.status = 0;
        this.stat2 = 0;
        this.stat3 = 0;
        this.len = 1;
        this.draw = false;
    }

    public void setLength(int len) {
        this.len = len;
        if (this.len < 1) {
            this.len = 1;
        }
        this.stat2 = len > this.status_width - 3 ? this.len / (this.status_width - 3) : (this.status_width - 3) / (len - 1);
    }

    public void start() {
        ++this.status;
        this.draw = true;
    }

    public boolean working() {
        if (!this.draw) {
            this.start();
            return true;
        }
        if (this.len > this.status_width - 3) {
            if (this.stat3 >= this.len) {
                return false;
            }
            ++this.stat3;
            if (this.stat3 > this.stat2) {
                ++this.status;
                this.stat3 = 0;
                return true;
            }
            return false;
        }
        this.status += this.stat2;
        if (this.status > this.status_width - 3) {
            this.status = this.status_width - 3;
        }
        return true;
    }

    public void paint(Graphics g) {
        if (this.draw) {
            int col = g.getColor();
            g.setColor(fill_color);
            g.fillRect(this.status_x + 2, this.status_y + 2, this.status, this.status_height - 3);
            g.setColor(rect_color);
            g.drawRect(this.status_x, this.status_y, this.status_width, this.status_height);
            g.setColor(border_color);
            g.drawRect(this.status_x + 1, this.status_y + 1, this.status_width - 2, this.status_height - 2);
            g.setColor(col);
        }
    }
}

