/*
 * Decompiled with CFR 0.152.
 */
package graphics;

import graphics.ScrollBar;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import util.CountRows;

public class TextDialog
extends Canvas {
    private Vector text;
    private Image back;
    protected ScrollBar scroll_bar = null;
    private CountRows cr;
    private int shift;
    private Font font;
    private int font_height;
    private int rows_per_screen;
    private int position = 0;
    private int max_pos = 1;
    private int bar_size = 0;
    private CommandListener cmd;
    private Command fire_command;
    private int textcolor = 0;
    private int backcolor = 0xFFFFFF;

    public TextDialog(String text, Font font, Image back, Command fire_command) {
        this.back = back;
        this.font = font == null ? Font.getDefaultFont() : font;
        this.shift = 0;
        this.font_height = font.getHeight();
        this.rows_per_screen = this.getHeight() / this.font_height;
        this.bar_size = this.getWidth() / 30 + 1;
        this.cr = new CountRows(this.getWidth() - 2 * this.bar_size, this.font);
        this.set_text(text);
        this.fire_command = fire_command;
        this.repaint();
    }

    protected void showNotify() {
        this.repaint();
    }

    public void set_text(String text) {
        this.position = 0;
        this.text = this.cr.rows(text);
        this.scroll_bar = null;
        this.max_pos = this.text.size() - this.rows_per_screen;
        if (this.max_pos < 1) {
            this.cr = new CountRows(this.getWidth() - this.bar_size, this.font);
            this.text = this.cr.rows(text);
            this.max_pos = 0;
        } else {
            this.scroll_bar = new ScrollBar();
            this.scroll_bar.setParameters(this.max_pos + 1, this.getWidth(), this.getHeight());
        }
        this.repaint();
    }

    public void set_fire_command(Command fc) {
        this.fire_command = fc;
    }

    public void set_textcolor(int col) {
        this.textcolor = col;
    }

    public void set_backcolor(int col) {
        this.backcolor = col;
    }

    public ScrollBar get_scrollbar() {
        return this.scroll_bar;
    }

    public void setCommandListener(CommandListener cmdls) {
        this.cmd = cmdls;
        super.setCommandListener(cmdls);
    }

    protected void keyPressed(int keyCode) {
        int key = this.getGameAction(keyCode);
        switch (key) {
            case 8: {
                if (this.fire_command != null) {
                    this.cmd.commandAction(this.fire_command, (Displayable)this);
                }
                return;
            }
            case 6: {
                ++this.position;
                if (this.position < this.max_pos) break;
                this.position = this.max_pos;
                break;
            }
            case 1: {
                --this.position;
                if (this.position >= 1) break;
                this.position = 0;
                break;
            }
            case 2: {
                this.position -= this.rows_per_screen - 1;
                if (this.position >= 0) break;
                this.position = 0;
                break;
            }
            case 5: {
                this.position += this.rows_per_screen - 1;
                if (this.position < this.max_pos) break;
                this.position = this.max_pos;
            }
        }
        this.repaint();
    }

    protected void paint(Graphics g) {
        g.setFont(this.font);
        g.setColor(this.backcolor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.textcolor);
        if (this.back != null) {
            g.drawImage(this.back, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
        int i = this.position;
        while (i < this.text.size()) {
            if (i > this.position + this.rows_per_screen) break;
            g.drawString((String)this.text.elementAt(i), this.bar_size / 2, 2 + (i - this.position) * this.font_height, 20);
            ++i;
        }
        if (this.scroll_bar != null) {
            this.scroll_bar.paint(this.position, g);
        }
    }
}

