/*
 * Decompiled with CFR 0.152.
 */
package mapy;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import util.Data;
import util.Utf8;

public class Location {
    public String description;
    public String short_desc;
    public String type;
    public long cx;
    public long cy;
    public long def_scale;
    public long px;
    public long py;
    public int def_x;
    public int def_y;
    public int def_scale_level;
    public boolean point;

    public Location() {
        this.cx = 0L;
        this.cy = 0L;
        this.px = 0L;
        this.py = 0L;
        this.point = true;
        this.def_scale = 0L;
        this.def_scale_level = 0;
        this.description = "";
        this.short_desc = "";
        this.type = "";
    }

    public Location(String description, String short_desc, String type, long cx, long cy, int def_scale_level, long def_scale, long px, long py, int def_x, int def_y) {
        this.description = description;
        this.short_desc = short_desc;
        this.type = type;
        this.cx = cx;
        this.cy = cy;
        this.def_scale = def_scale;
        this.def_scale_level = def_scale_level;
        this.def_x = def_x;
        this.def_y = def_y;
        this.py = py;
        this.px = px;
    }

    public Location getCopy() {
        return new Location(this.description, this.short_desc, this.type, this.cx, this.cy, this.def_scale_level, this.def_scale, this.px, this.py, this.def_x, this.def_y);
    }

    public Location(InputStream is) throws Exception {
        DataInputStream dis = new DataInputStream(is);
        this.description = Data.getNextString(dis);
        this.short_desc = Data.getNextString(dis);
        this.type = Data.getNextString(dis);
        if (this.description.equals("") || this.short_desc.equals("") || this.type.equals("")) {
            throw new IOException();
        }
        this.cx = dis.readLong();
        this.cy = dis.readLong();
        this.px = dis.readLong();
        this.py = dis.readLong();
        this.def_scale_level = dis.readInt();
        this.def_scale = dis.readLong();
        this.def_x = dis.readInt();
        this.def_y = dis.readInt();
    }

    public byte[] getBytes() {
        byte[] block = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            byte[] tmp = Utf8.getBytes(this.description);
            out.write(("" + tmp.length + "\n").getBytes());
            out.write(tmp);
            tmp = Utf8.getBytes(this.short_desc);
            out.write(("" + tmp.length + "\n").getBytes());
            out.write(tmp);
            tmp = Utf8.getBytes(this.type);
            out.write(("" + tmp.length + "\n").getBytes());
            out.write(tmp);
            out.writeLong(this.cx);
            out.writeLong(this.cy);
            out.writeLong(this.px);
            out.writeLong(this.py);
            out.writeInt(this.def_scale_level);
            out.writeLong(this.def_scale);
            out.writeInt(this.def_x);
            out.writeInt(this.def_y);
            block = baos.toByteArray();
        }
        catch (Exception e) {
            block = null;
        }
        return block;
    }
}

