/*
 * Decompiled with CFR 0.152.
 */
package mapy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import mapy.Location;
import mapy.MapBlock;

public class MapHandler {
    private RecordStore record_store = RecordStore.openRecordStore((String)"MAPS", (boolean)true);
    private Vector locations = new Vector();

    public void getData() throws Exception {
        this.locations = this.loadLocs();
    }

    public void close() {
        try {
            this.record_store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.record_store = null;
    }

    public void setLocs(Vector locs) throws Exception {
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        Enumeration enu = locs.elements();
        while (enu.hasMoreElements()) {
            Location l = (Location)enu.nextElement();
            try {
                bais.write(l.getBytes());
            }
            catch (Exception e) {
                break;
            }
        }
        byte[] bytes = bais.toByteArray();
        if (this.record_store.getNumRecords() == 0) {
            this.record_store.addRecord(bytes, 0, bytes.length);
        } else {
            this.record_store.setRecord(1, bytes, 0, bytes.length);
        }
        this.locations = locs;
    }

    public Vector loadLocs() throws Exception {
        Vector<Location> locs = new Vector<Location>();
        if (this.record_store.getNumRecords() == 0) {
            return locs;
        }
        byte[] bytes = this.record_store.getRecord(1);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        while (bais.available() > 0) {
            locs.addElement(new Location(bais));
        }
        return locs;
    }

    public Vector getLocs() {
        return this.locations;
    }

    public void addLoc(Location loc) throws Exception {
        Vector locs = this.getLocs();
        locs.addElement(loc);
        this.setLocs(locs);
    }

    public void delLoc(int index) throws Exception {
        String name = ((Location)this.locations.elementAt((int)index)).short_desc;
        this.locations.removeElementAt(index);
        this.setLocs(this.locations);
        int in = 0;
        while (in < this.mapCount()) {
            try {
                MapBlock block = this.mapAt(in);
                if (block.name.equals(name)) {
                    this.record_store.deleteRecord(block.id + 2);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++in;
        }
    }

    public MapBlock mapAt(int index) throws Exception {
        MapBlock b = new MapBlock(this.record_store.getRecord(index + 2));
        b.id = index;
        return b;
    }

    public int mapCount() {
        try {
            return this.record_store.getNextRecordID() - 2;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void addMap(MapBlock map) throws Exception {
        byte[] bytes = map.getBytes();
        if (this.record_store.getNumRecords() == 0) {
            byte[] by = new byte[]{0};
            this.record_store.addRecord(by, 0, by.length);
        }
        int n = this.record_store.addRecord(bytes, 0, bytes.length);
    }
}

