/*
 * Decompiled with CFR 0.152.
 */
package mapy;

import graphics.GaugeScreen;
import graphics.TextDialog;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import mapy.BadKey;
import mapy.Commands;
import mapy.Key;
import mapy.Location;
import mapy.MapBlock;
import mapy.MapHandler;
import mapy.Maps;
import mapy.Mapy;
import mapy.Point;
import mapy.WapPush;
import util.CountRows;
import util.EventHandler;
import util.SMS;

public class MapView
extends Canvas
implements CommandListener {
    public static final int bc = 254;
    public static final int res = 960000;
    public static final int min_zoom = 0;
    public static final int max_zoom = 30;
    private final int size;
    public static int cache_max_size;
    private int cache_size;
    private static int border_color;
    private static int rect_color;
    private static int fill_color;
    private Vector cache;
    private Image sign_img;
    private Image point;
    private Image back;
    private TextBox name_request;
    private TextBox number_request;
    private int imgs_shift_x;
    private int imgs_shift_y;
    private int vert_pos;
    private int hor_pos;
    private int last_vpos;
    private int last_hpos;
    private int hpos_down;
    private int vpos_down;
    private boolean moving = false;
    private int status = 0;
    private MapBlock[][] maps;
    private MapBlock current_block;
    private Location loc;
    private boolean history_previous;
    private CountRows rows;
    private int font_height;
    private Key key;
    private long coor_x;
    private long coor_y;
    private long last_cx;
    private long last_cy;
    private long scale;
    private int scale_level;
    private int img_width;
    private int img_height;
    private int x_unit;
    private int y_unit;
    private int sign_x;
    private int sign_y;
    private boolean sign = false;
    private boolean asked = false;
    private boolean overwrite = false;
    private Font font;
    private String lid;
    private String operation;
    private TextDialog sign_request;
    private TextDialog error;
    private TextDialog save_request;
    private TextDialog send_request;
    private Display display;
    private GaugeScreen zoom_meter;
    private Maps maps_data;
    private Point down;
    private Displayable backsc;
    private Displayable next_screen;
    private CommandListener cmdls;
    private BadKey badKey;
    private MapHandler map_handler;
    private Vector history;
    private int history_position;
    private int history_max_size = 20;
    private EventHandler event_handler;
    private WapPush wappush;

    public MapView(Image back, Display display, Key key, MapHandler mh) {
        this.size = 3;
        this.map_handler = mh;
        this.cache = new Vector();
        this.cache_size = cache_max_size;
        this.wappush = new WapPush();
        this.wappush.setCommandListener(this);
        this.display = display;
        this.key = key;
        this.coor_x = 0L;
        this.coor_y = 0L;
        try {
            this.point = this.getHeight() >= 128 ? Image.createImage((String)"/sipkab24.png") : Image.createImage((String)"/sipkab14.png");
        }
        catch (Exception e) {
            this.point = null;
        }
        try {
            this.sign_img = this.getHeight() >= 128 ? Image.createImage((String)"/sign24.PNG") : Image.createImage((String)"/sign14.PNG");
        }
        catch (Exception e) {
            this.sign_img = null;
        }
        this.name_request = new TextBox("Ulo\u017eit jako", "", 50, 0);
        this.name_request.addCommand(Commands.save);
        this.name_request.addCommand(Commands.back);
        this.name_request.setCommandListener((CommandListener)this);
        this.number_request = new TextBox("\u010c\u00edslo p\u0159\u00edjemce", "", 50, 3);
        this.number_request.addCommand(Commands.send);
        this.number_request.addCommand(Commands.back);
        this.number_request.setCommandListener((CommandListener)this);
        this.setCommandListener(this);
        this.addCommand(Commands.back);
        this.addCommand(Commands.zoom_shift);
        this.addCommand(Commands.send);
        this.addCommand(Commands.save);
        this.zoom_meter = new GaugeScreen(back, Commands.ok);
        this.zoom_meter.setCommandListener(this);
        this.zoom_meter.addCommand(Commands.ok);
        this.zoom_meter.addCommand(Commands.back);
        this.zoom_meter.setMaxValue(30);
        this.zoom_meter.setTitle("P\u0159ibl\u00ed\u017een\u00ed");
        this.zoom_meter.setLegend("Nejd\u00e1l", "Nejbl\u00ed\u017e");
        this.send_request = new TextDialog("", Font.getFont((int)0, (int)1, (int)0), back, Commands.yes);
        this.send_request.addCommand(Commands.yes);
        this.send_request.addCommand(Commands.no);
        this.send_request.setCommandListener(this);
        this.save_request = new TextDialog("Zadan\u00fd n\u00e1zev ji\u017e existuje, p\u0159ejete si p\u0159epsat ulo\u017eenou mapu?", Font.getFont((int)0, (int)1, (int)0), back, Commands.no);
        this.save_request.addCommand(Commands.yes);
        this.save_request.addCommand(Commands.no);
        this.save_request.setCommandListener(this);
        this.sign_request = new TextDialog("P\u0159ejete si ozna\u010dit objekt pro p\u0159\u00edjemce?", Font.getFont((int)0, (int)1, (int)0), back, Commands.yes);
        this.sign_request.addCommand(Commands.yes);
        this.sign_request.addCommand(Commands.no);
        this.sign_request.set_fire_command(Commands.yes);
        this.sign_request.setCommandListener(this);
        this.maps_data = new Maps(key, this.getWidth() * 2, this.getHeight() * 2);
        this.maps_data.setCommandListener(this);
        this.badKey = new BadKey(display, key, back);
        this.vert_pos = 0;
        this.hor_pos = 0;
        this.font = Font.getFont((int)0, (int)1, (int)8);
        this.rows = new CountRows(this.getWidth() - 8, this.font);
        this.back = back;
        this.maps = new MapBlock[3][3];
        this.font_height = this.font.getHeight();
        this.img_width = this.getWidth() * 2;
        this.img_height = this.getHeight() * 2;
        this.x_unit = this.getWidth() / 4;
        this.y_unit = this.getHeight() / 4;
        this.history_position = -1;
        this.history = new Vector();
    }

    private void historyCommands() {
        this.removeCommand(Commands.previous);
        this.removeCommand(Commands.next);
        if (this.history.size() > 0) {
            if (this.history_position > 0) {
                this.addCommand(Commands.previous);
            }
            if (this.history_position < this.history.size() - 1) {
                this.addCommand(Commands.next);
            }
        }
    }

    private Location previous() {
        if (this.history_position > 0) {
            --this.history_position;
            this.historyCommands();
            return (Location)this.history.elementAt(this.history_position);
        }
        return null;
    }

    private Location next() {
        if (this.history_position < this.history.size() - 1) {
            ++this.history_position;
            this.historyCommands();
            return (Location)this.history.elementAt(this.history_position);
        }
        return null;
    }

    private void addToHistory(Location l) {
        while (this.history_position + 1 < this.history.size()) {
            this.history.removeElementAt(this.history.size() - 1);
        }
        if (this.history.size() >= this.history_max_size) {
            this.history.removeElementAt(0);
        }
        ++this.history_position;
        this.history.addElement(l);
        this.historyCommands();
    }

    public void setEventHandler(EventHandler eh) {
        this.event_handler = eh;
    }

    public void setCacheSize(int i) {
        this.cache_size = i;
    }

    public void setCommandListener(CommandListener cmdls) {
        this.cmdls = cmdls;
        super.setCommandListener(cmdls);
    }

    protected void showNotify() {
        this.repaint();
    }

    private Point viewedImage(int hor_pos, int vert_pos) {
        int i = (Math.abs(hor_pos) + 2) / 5;
        if (hor_pos < 0) {
            i = -i;
        }
        int j = (Math.abs(vert_pos) + 2) / 5;
        if (vert_pos < 0) {
            j = -j;
        }
        return new Point(++i, ++j);
    }

    protected void keyPressed(int keyCode) {
        this.operation = "move";
        int key = this.getGameAction(keyCode);
        if (this.asked) {
            if (key == 8) {
                this.commandAction(Commands.yes, (Displayable)this);
                return;
            }
            this.asked(false);
        }
        this.last_vpos = this.vert_pos--;
        this.last_hpos = this.hor_pos--;
        boolean imgs_shift = false;
        this.imgs_shift_y = 0;
        this.imgs_shift_x = 0;
        this.moving = false;
        switch (keyCode) {
            case 51: {
                this.commandAction(Commands.zoom_in, (Displayable)this);
                return;
            }
            case 49: {
                this.commandAction(Commands.zoom_out, (Displayable)this);
                return;
            }
        }
        switch (key) {
            case 8: {
                if (this.sign) {
                    this.commandAction(Commands.sign, (Displayable)this);
                    return;
                }
                if (this.asked) {
                    this.commandAction(Commands.yes, (Displayable)this);
                    return;
                }
                this.commandAction(Commands.zoom_shift, (Displayable)this);
            }
            case 6: {
                if (!this.sign) {
                    ++this.vert_pos;
                    this.imgs_shift_y = 1;
                    this.moving = true;
                    break;
                }
                this.sign_y += 3;
                if (this.sign_y <= this.getHeight() / 2) break;
                this.sign_y = this.getHeight() / 2;
                break;
            }
            case 1: {
                if (!this.sign) {
                    this.imgs_shift_y = -1;
                    this.moving = true;
                    break;
                }
                this.sign_y -= 3;
                if (this.sign_y >= -this.getHeight() / 2) break;
                this.sign_y = -this.getHeight() / 2;
                break;
            }
            case 2: {
                if (!this.sign) {
                    this.imgs_shift_x = -1;
                    this.moving = true;
                    break;
                }
                this.sign_x -= 3;
                if (this.sign_x >= -this.getWidth() / 2) break;
                this.sign_x = -this.getWidth() / 2;
                break;
            }
            case 5: {
                if (!this.sign) {
                    ++this.hor_pos;
                    this.imgs_shift_x = 1;
                    this.moving = true;
                    break;
                }
                this.sign_x += 3;
                if (this.sign_x <= this.getWidth() / 2) break;
                this.sign_x = this.getWidth() / 2;
            }
        }
        Point p = this.viewedImage(this.hor_pos, this.vert_pos);
        boolean ok = false;
        if (this.check(p.x, p.y)) {
            if (this.maps[p.x][p.y] != null) {
                ok = true;
            }
        } else {
            imgs_shift = true;
        }
        if (!ok) {
            this.status = 2;
            this.down = new Point(p.x - 1, p.y - 1);
            if (!imgs_shift) {
                this.imgs_shift_x = 0;
                this.imgs_shift_y = 0;
            }
            long cx = this.coor_x + (long)this.down.x * (5L * ((long)(this.img_width * 254) * this.scale / 960000L) / 8L);
            long cy = this.coor_y - (long)this.down.y * (5L * ((long)(this.img_height * 254) * this.scale / 960000L) / 8L);
            this.last_cx = this.coor_x;
            this.last_cy = this.coor_y;
            MapBlock block = this.getCachedBlock(cx, cy, this.scale_level);
            if (block != null) {
                this.downloadImage(this.down.x, this.down.y);
            } else {
                this.asked(true);
            }
        }
        this.repaint();
    }

    public boolean check(long x, long y) {
        if (x < 0L) {
            return false;
        }
        if (x >= 3L) {
            return false;
        }
        if (y < 0L) {
            return false;
        }
        return y < 3L;
    }

    protected void paint(Graphics g) {
        int vp;
        int hp;
        if (this.asked) {
            hp = this.last_hpos;
            vp = this.last_vpos;
        } else {
            hp = this.hor_pos;
            vp = this.vert_pos;
        }
        Point p = this.viewedImage(hp, vp);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.maps != null) {
            if (this.check(p.x, p.y) && this.maps[p.x][p.y] != null) {
                MapBlock block;
                int cx = 5 * (p.x - 1) - hp;
                int cy = 5 * (p.y - 1) - vp;
                this.current_block = block = this.maps[p.x][p.y];
                g.drawImage(block.map, this.getWidth() / 2 + cx * this.x_unit, this.getHeight() / 2 + cy * this.y_unit, 3);
                if (!this.sign) {
                    if (block.coor_x == this.loc.px && block.coor_y == this.loc.py && this.point != null) {
                        g.drawImage(this.point, this.getWidth() / 2 + cx * this.x_unit, this.getHeight() / 2 + cy * this.y_unit, 24);
                    }
                } else {
                    g.drawImage(this.sign_img, this.getWidth() / 2 + this.sign_x, this.getHeight() / 2 + this.sign_y, 24);
                }
            }
            if (this.asked) {
                String s = "Chcete st\u00e1hnout vedlej\u0161\u00ed mapu?";
                Vector lines = this.rows.rows(s);
                int height = 10 + lines.size() * this.font_height;
                g.setColor(fill_color);
                g.fillRect(2, 2, this.getWidth() - 4, height - 4);
                g.setColor(rect_color);
                g.drawRect(0, 0, this.getWidth() - 1, height - 1);
                g.setColor(border_color);
                g.drawRect(1, 1, this.getWidth() - 3, height - 3);
                g.setFont(this.font);
                g.setColor(0);
                int i = 0;
                while (i < lines.size()) {
                    g.drawString((String)lines.elementAt(i), 4, 5 + i * this.font_height, 20);
                    ++i;
                }
            }
        }
    }

    public void setBackscreen(Displayable disp) {
        this.backsc = disp;
    }

    public Displayable getBackscreen() {
        return this.backsc;
    }

    public void asked(boolean asked) {
        this.asked = asked;
        if (!asked) {
            this.removeCommand(Commands.yes);
            this.removeCommand(Commands.no);
            this.hor_pos = this.last_hpos;
            this.vert_pos = this.last_vpos;
        } else {
            this.addCommand(Commands.yes);
            this.addCommand(Commands.no);
            this.hpos_down = this.hor_pos;
            this.vpos_down = this.vert_pos;
        }
    }

    public void setZoom(int zoom, boolean change_coordinates) {
        this.operation = "zoom";
        this.scale_level = zoom;
        this.zoom_meter.setValue(zoom);
        if (change_coordinates) {
            this.last_cx = this.coor_x;
            this.last_cy = this.coor_y;
            this.coor_x += (long)this.hor_pos * (long)this.x_unit * 254L * this.scale / 960000L;
            this.coor_y -= (long)this.vert_pos * (long)this.y_unit * 254L * this.scale / 960000L;
        }
    }

    public void loadMap(Location l) {
        this.lid = Mapy.generateLid();
        this.operation = "load";
        this.status = 3;
        this.coor_x = l.cx;
        this.coor_y = l.cy;
        this.hor_pos = l.def_x;
        this.vert_pos = l.def_y;
        this.scale = l.def_scale;
        this.setZoom(l.def_scale_level, false);
        this.imgs_shift_x = 0;
        this.imgs_shift_y = 0;
        this.loc = l.getCopy();
        String err = "";
        int i = 0;
        while (i < this.map_handler.mapCount()) {
            try {
                MapBlock block = this.map_handler.mapAt(i);
                if (block.name.equals(l.short_desc)) {
                    this.toCache(block);
                }
            }
            catch (Exception e) {
                err = err + e.toString();
            }
            ++i;
        }
        Point p = this.viewedImage(this.hor_pos, this.vert_pos);
        this.down = new Point(p.x - 1, p.y - 1);
        long cx = this.coor_x + 5L * ((long)(this.down.x * this.img_width * 254) * this.scale / 960000L) / 8L;
        long cy = this.coor_y - 5L * ((long)(this.down.y * this.img_height * 254) * this.scale / 960000L) / 8L;
        if (this.getCachedBlock(cx, cy, this.scale_level) != null) {
            this.downloadImage(this.down.x, this.down.y);
        } else {
            this.display.setCurrent(new Alert("Chyba", "Chyba p\u0159i p\u0159\u00edstupu k map\u011b.", null, AlertType.INFO), this.backsc);
        }
    }

    public void setLocation(Location l) {
        this.lid = Mapy.generateLid();
        this.last_cx = this.coor_x;
        this.last_cy = this.coor_y;
        this.coor_x = l.cx;
        this.coor_y = l.cy;
        this.imgs_shift_x = 0;
        this.imgs_shift_y = 0;
        if (!l.type.equals("saved")) {
            this.status = 1;
            if (l.type.charAt(0) == 'O') {
                this.setZoom(14, false);
            }
            if (l.type.charAt(0) == '\u010c') {
                this.setZoom(17, false);
            }
            if (l.type.charAt(0) == 'U') {
                this.setZoom(25, false);
            }
        } else {
            this.status = 4;
            this.scale = l.def_scale;
            this.setZoom(l.def_scale_level, false);
        }
        this.loc = l;
        this.operation = "new";
        MapBlock block = this.getCachedBlock(this.coor_x, this.coor_y, this.scale_level);
        if (block != null) {
            this.updateData(block);
        } else {
            this.maps_data.getMap(this.coor_x, this.coor_y, this.scale_level, this.operation, this.lid);
            this.display.setCurrent((Displayable)this.maps_data);
        }
    }

    public void showString(String text, Command c, Displayable next) {
        this.error = new TextDialog("", Font.getFont((int)0, (int)1, (int)0), this.back, null);
        this.error.addCommand(c);
        this.error.set_fire_command(c);
        this.error.setCommandListener(this);
        this.error.set_text(text);
        this.next_screen = next;
        this.error.repaint();
        this.display.setCurrent((Displayable)this.error);
    }

    public void downloadImage(int x, int y) {
        long jump_x = 5L * ((long)(this.img_width * 254) * this.scale / 960000L) / 8L;
        long cx = this.coor_x + (long)x * jump_x;
        long jump_y = 5L * ((long)(this.img_height * 254) * this.scale / 960000L) / 8L;
        long cy = this.coor_y - (long)y * jump_y;
        MapBlock block = this.getCachedBlock(cx, cy, this.scale_level);
        if (block != null) {
            this.updateData(block);
        } else {
            this.display.setCurrent((Displayable)this.maps_data);
            this.maps_data.getMap(cx, cy, this.scale_level, this.operation, this.lid);
        }
    }

    public void removeMapBlock() {
        int max_index = 0;
        if (this.cache.size() < 1) {
            return;
        }
        long max = 0L;
        max_index = 0;
        int i = 0;
        while (i < this.cache.size()) {
            MapBlock bl = (MapBlock)this.cache.elementAt(i);
            long c = Math.abs(bl.coor_x - this.current_block.coor_x) + Math.abs(bl.coor_y - this.current_block.coor_y);
            if (c > max) {
                max = c;
                max_index = i;
            }
            ++i;
        }
        this.cache.removeElementAt(max_index);
    }

    public void toCache(MapBlock block) {
        if (this.cache_size > 0) {
            if (this.cache.size() >= this.cache_size) {
                this.removeMapBlock();
            }
            this.cache.addElement(block);
        }
    }

    public MapBlock getCachedBlock(long cx, long cy, long sc) {
        Enumeration enu = this.cache.elements();
        MapBlock block = null;
        while (enu.hasMoreElements()) {
            block = (MapBlock)enu.nextElement();
            if (cx != block.coor_x || cy != block.coor_y || sc != (long)block.scale_level) continue;
            return block;
        }
        return null;
    }

    public void updateData() {
        try {
            MapBlock block = this.maps_data.getMapBlock();
            this.toCache(block);
            this.updateData(block);
        }
        catch (Throwable e) {
            this.processError("Chyba p\u0159i spracov\u00e1n\u00ed dat" + e.toString());
        }
    }

    public void updateData(MapBlock block) {
        try {
            if (this.status != 2 && this.status != 3) {
                this.maps = null;
                this.maps = new MapBlock[3][3];
                this.maps[1][1] = block;
                this.hor_pos = 0;
                this.vert_pos = 0;
                this.last_hpos = this.hor_pos;
                this.last_vpos = this.vert_pos;
                if (this.status == 1) {
                    this.addToHistory(new Location(this.loc.description, this.loc.short_desc, "saved", block.coor_x, block.coor_y, block.scale_level, block.scale, this.loc.px, this.loc.py, 0, 0));
                }
                if (this.status == 5) {
                    this.addToHistory(new Location(this.loc.description, this.loc.short_desc, "saved", block.coor_x, block.coor_y, block.scale_level, block.scale, 0L, 0L, 0, 0));
                }
                if (this.scale_level != block.scale_level && this.status != 1) {
                    if (this.scale_level < block.scale_level) {
                        this.showString("Pro po\u017eadovanou lokaci nejsou dostupn\u00e9 m\u00e9n\u011b podrobn\u00e9 mapy. Zobraz\u00ed se mapa v nejv\u011bt\u0161\u00edm mo\u017en\u00e9m odd\u00e1len\u00ed.", Commands.ok, (Displayable)this);
                    } else {
                        this.showString("Pro po\u017eadovanou lokaci nejsou dostupn\u00e9 podrobn\u011bj\u0161\u00ed mapy. Zobraz\u00ed se mapa v nejv\u011bt\u0161\u00edm mo\u017en\u00e9m p\u0159ibl\u00ed\u017een\u00ed.", Commands.ok, (Displayable)this);
                    }
                } else {
                    this.display.setCurrent((Displayable)this);
                }
                this.scale = block.scale;
                this.setZoom(block.scale_level, false);
                this.repaint();
            } else {
                int img_n_y;
                int img_n_x;
                if (this.status == 3 || this.cache_size == 1) {
                    this.maps = null;
                    this.maps = new MapBlock[3][3];
                    this.addToHistory(new Location(this.loc.description, this.loc.short_desc, "saved", block.coor_x, block.coor_y, block.scale_level, block.scale, this.loc.px, this.loc.py, 0, 0));
                }
                if (this.imgs_shift_x != 0 || this.imgs_shift_y != 0) {
                    MapBlock[][] maps2 = new MapBlock[3][3];
                    int i = 0;
                    while (i < 3) {
                        int j = 0;
                        while (j < 3) {
                            if (this.check(i - this.imgs_shift_x, j - this.imgs_shift_y)) {
                                maps2[i - this.imgs_shift_x][j - this.imgs_shift_y] = this.maps[i][j];
                            }
                            ++j;
                        }
                        ++i;
                    }
                    this.maps = maps2;
                }
                if (this.check(img_n_x = this.down.x + 1 - this.imgs_shift_x, img_n_y = this.down.y + 1 - this.imgs_shift_y)) {
                    this.maps[img_n_x][img_n_y] = block;
                }
                this.coor_x += 5L * ((long)(this.imgs_shift_x * this.img_width * 254) * this.scale / 960000L) / 8L;
                this.coor_y -= 5L * ((long)(this.imgs_shift_y * this.img_height * 254) * this.scale / 960000L) / 8L;
                this.hor_pos -= this.imgs_shift_x * 5;
                this.vert_pos -= this.imgs_shift_y * 5;
                this.repaint();
                this.display.setCurrent((Displayable)this);
            }
        }
        catch (Throwable e) {
            this.processError("Chyba p\u0159i spracov\u00e1n\u00ed dat");
        }
    }

    public void processError(String error) {
        if (this.status == 1) {
            if (this.maps_data.canceled()) {
                this.display.setCurrent(new Alert("Zru\u0161eno", error, null, AlertType.INFO), this.backsc);
            } else {
                this.showString(error, Commands.ok, this.backsc);
            }
            return;
        }
        if (this.status == 4) {
            if (!this.history_previous) {
                this.setLocation(this.previous());
            } else {
                this.setLocation(this.next());
            }
            return;
        }
        this.scale = this.current_block.scale;
        this.scale_level = this.current_block.scale_level;
        this.coor_x = this.last_cx;
        this.coor_y = this.last_cy;
        this.vert_pos = this.last_vpos;
        this.hor_pos = this.last_hpos;
        if (this.maps_data.canceled()) {
            this.display.setCurrent(new Alert("Zru\u0161eno", error, null, AlertType.INFO), (Displayable)this);
        } else {
            this.showString(error, Commands.ok, (Displayable)this);
        }
    }

    public static String getRealPart(long x, int digits) {
        String s = x + "";
        while (s.length() < digits) {
            s = "0" + s;
        }
        return s;
    }

    public void onSaveCommand(Displayable disp) {
        if (disp == this) {
            try {
                this.name_request.setString(this.loc.short_desc);
                this.display.setCurrent((Displayable)this.name_request);
            }
            catch (Exception e) {
                this.name_request.setString("");
            }
        }
        if (disp == this.name_request) {
            boolean may = true;
            Vector locs = this.map_handler.getLocs();
            String name = this.name_request.getString();
            int index = locs.size() - 1;
            while (index >= 0) {
                Location l = (Location)locs.elementAt(index);
                if (l.short_desc.equals(name)) {
                    if (this.overwrite) {
                        try {
                            this.map_handler.delLoc(index);
                        }
                        catch (Exception e) {}
                    } else {
                        may = false;
                        break;
                    }
                }
                --index;
            }
            if (may) {
                String resp = "";
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        if (this.maps[i][j] != null) {
                            this.maps[i][j].setName(name);
                            try {
                                this.map_handler.addMap(this.maps[i][j]);
                            }
                            catch (Exception e) {
                                this.showString("Vyskytla se chyba p\u0159i ukl\u00e1d\u00e1n\u00ed ", Commands.ok, (Displayable)this);
                                return;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                Location lc = this.loc.getCopy();
                lc.def_scale = this.scale;
                lc.def_scale_level = this.scale_level;
                lc.short_desc = name;
                lc.def_x = this.hor_pos;
                lc.def_y = this.vert_pos;
                lc.cx = this.coor_x;
                lc.cy = this.coor_y;
                locs.addElement(lc);
                try {
                    this.map_handler.setLocs(locs);
                }
                catch (Exception e) {
                    this.showString("Vyskytla se chyba p\u0159i ukl\u00e1d\u00e1n\u00ed ", Commands.ok, (Displayable)this);
                    return;
                }
                this.display.setCurrent((Displayable)this);
            } else {
                this.display.setCurrent((Displayable)this.save_request);
            }
        }
    }

    public void onSendCommand(Displayable disp) {
        if (disp == this) {
            this.number_request.setString("");
            if (this.sign_img != null) {
                this.display.setCurrent((Displayable)this.sign_request);
            } else {
                this.display.setCurrent(new Alert("Mapa", "Zadejte \u010d\u00edslo p\u0159\u00edjemce mapy.", null, AlertType.INFO), (Displayable)this.number_request);
            }
        }
        if (disp == this.number_request) {
            long real_cy;
            String to = this.number_request.getString();
            if (to.length() < 1) {
                this.display.setCurrent(new Alert("Chyba", "Zadejte \u010d\u00edslo p\u0159\u00edjemce mapy", null, AlertType.ERROR), (Displayable)this.number_request);
                return;
            }
            if (to.length() == 9) {
                to = "+420" + to;
            }
            long cx = this.coor_x + (long)this.hor_pos * (long)this.x_unit * 254L * this.scale / 960000L;
            long cy = this.coor_y - (long)this.vert_pos * (long)this.y_unit * 254L * this.scale / 960000L;
            long real_cx = -((long)(this.hor_pos * this.x_unit * 254) * this.scale / 960L % 1000L);
            if (real_cx < 0L) {
                ++cx;
                real_cx = 1000L + real_cx;
            }
            if ((real_cy = (long)(this.vert_pos * this.y_unit * 254) * this.scale / 960L % 1000L) < 0L) {
                ++cy;
                real_cy = 1000L + real_cy;
            }
            this.wappush.order(cx + "." + MapView.getRealPart(real_cx, 3), cy + "." + MapView.getRealPart(real_cy, 3), this.scale_level + "", to, this.sign_x + "", this.sign_y + "", this.sign);
            this.display.setCurrent((Displayable)this.wappush);
        }
    }

    public void sendWapPush(String number, String sms_code) {
        this.sign = false;
        this.removeCommand(Commands.sign);
        this.addCommand(Commands.send);
        try {
            try {
                Class.forName("javax.wireless.messaging.MessageConnection");
            }
            catch (Exception e) {
                this.showString("V\u00e1\u0161 telefon nepodporuje odes\u00edl\u00e1n\u00ed SMS z Java aplikac\u00ed. Ode\u0161lete pros\u00edm ru\u010dn\u011b zpr\u00e1vu s textem \"" + sms_code + "\" na \u010d\u00edslo " + number + ".", Commands.ok, (Displayable)this);
                return;
            }
            SMS.sendSMS(sms_code, number);
            this.showString("P\u0159\u00edjemce obdr\u017e\u00ed obrazovou zpr\u00e1vu v pr\u016fb\u011bhu n\u011bkolika minut.", Commands.ok, (Displayable)this);
        }
        catch (SecurityException se) {
            this.showString("Operace nebyla povolena u\u017eivatelem nebo nastaven\u00edm telefonu.", Commands.ok, (Displayable)this);
        }
        catch (Exception e) {
            this.showString("Chyba v odesl\u00e1n\u00ed sms\n\u010c\u00edslo:" + number + "\nText zpr\u00e1vy:" + sms_code, Commands.ok, (Displayable)this);
        }
    }

    public void commandAction(Command c, Displayable disp) {
        if (this.asked) {
            this.asked(false);
        }
        if (disp == this.error) {
            this.display.setCurrent(this.next_screen);
            return;
        }
        if (c == Commands.sign && disp == this) {
            this.display.setCurrent(new Alert("Mapa", "Zadejte \u010d\u00edslo p\u0159\u00edjemce mapy.", null, AlertType.INFO), (Displayable)this.number_request);
        }
        if (c == Commands.send) {
            this.onSendCommand(disp);
        }
        if (c == Commands.back) {
            if (disp == this) {
                if (!this.sign) {
                    if (this.event_handler != null) {
                        this.event_handler.handle(EventHandler.BACK, (Object)this);
                    }
                } else {
                    this.sign = false;
                    this.removeCommand(Commands.sign);
                    this.addCommand(Commands.send);
                    this.repaint();
                }
            }
            if (disp == this.number_request) {
                this.display.setCurrent((Displayable)this);
            }
            if (disp == this.zoom_meter || disp == this.name_request) {
                this.display.setCurrent((Displayable)this);
            }
        }
        if (c == Commands.save) {
            this.onSaveCommand(disp);
        }
        if (c == Commands.cancel) {
            this.maps_data.exit();
        }
        if (c == Commands.zoom_in) {
            if (this.zoom_meter.getValue() + 1 > 30) {
                return;
            }
            this.setZoom(this.scale_level + 1, true);
            this.commandAction(Commands.ok, (Displayable)this.zoom_meter);
        }
        if (c == Commands.zoom_out) {
            this.setZoom(this.scale_level - 1, true);
            this.commandAction(Commands.ok, (Displayable)this.zoom_meter);
        }
        if (c == Commands.zoom_shift) {
            this.zoom_meter.setValue(this.scale_level);
            this.display.setCurrent((Displayable)this.zoom_meter);
        }
        if (c == Commands.ok && disp == this.zoom_meter) {
            this.setZoom(this.zoom_meter.getValue(), true);
            this.display.setCurrent((Displayable)this.maps_data);
            this.status = 5;
            MapBlock block = this.getCachedBlock(this.coor_x, this.coor_y, this.scale_level);
            if (block != null) {
                this.updateData(block);
            } else {
                this.maps_data.getMap(this.coor_x, this.coor_y, this.scale_level, this.operation, this.lid);
            }
        }
        if (c == Commands.bad_key) {
            if (this.status == 1) {
                this.badKey.badKey(this.backsc, this.maps_data.possibilities());
            } else {
                if (this.moving) {
                    this.vert_pos = this.last_vpos;
                    this.hor_pos = this.last_hpos;
                }
                this.badKey.badKey((Displayable)this, this.maps_data.possibilities());
            }
        }
        if (c == Commands.update_data) {
            if (disp == this.maps_data) {
                this.updateData();
            }
            if (disp == this.wappush) {
                this.send_request.set_text(this.wappush.getRequestText());
                this.display.setCurrent((Displayable)this.send_request);
            }
            return;
        }
        if (c == Commands.yes) {
            if (disp == this.send_request) {
                this.sendWapPush(this.wappush.getNumber(), this.wappush.getSmsCode());
            }
            if (disp == this) {
                this.hor_pos = this.hpos_down;
                this.vert_pos = this.vpos_down;
                this.downloadImage(this.down.x, this.down.y);
            }
            if (disp == this.sign_request) {
                this.sign = true;
                this.sign_x = 0;
                this.sign_y = 0;
                this.addCommand(Commands.sign);
                this.removeCommand(Commands.send);
                this.display.setCurrent((Displayable)this);
            }
            if (disp == this.save_request) {
                this.overwrite = true;
                this.commandAction(Commands.save, (Displayable)this.name_request);
            }
        }
        if (c == Commands.no) {
            if (disp == this) {
                this.display.setCurrent((Displayable)this);
                this.vert_pos = this.last_vpos;
                this.hor_pos = this.last_hpos;
                this.repaint();
            }
            if (disp == this.send_request) {
                this.sign = false;
                this.removeCommand(Commands.sign);
                this.addCommand(Commands.send);
                this.display.setCurrent((Displayable)this);
            }
            if (disp == this.sign_request) {
                this.display.setCurrent(new Alert("Mapa", "Zadejte \u010d\u00edslo p\u0159\u00edjemce mapy.", null, AlertType.INFO), (Displayable)this.number_request);
            }
            if (disp == this.save_request) {
                this.display.setCurrent((Displayable)this.name_request);
            }
        }
        if (c == Commands.error) {
            if (disp == this.maps_data) {
                this.processError(this.maps_data.getError());
            }
            if (disp == this.wappush) {
                this.processError(this.wappush.getError());
            }
        }
        if (c == Commands.previous) {
            this.status = 4;
            this.history_previous = true;
            this.setLocation(this.previous());
        }
        if (c == Commands.next) {
            this.status = 4;
            this.history_previous = false;
            this.setLocation(this.next());
        }
    }

    static {
        bc = 254;
        res = 960000;
        min_zoom = 0;
        max_zoom = 30;
        cache_max_size = 4;
        border_color = 0x8D8D8D;
        rect_color = 0;
        fill_color = 0xCDCDCD;
    }
}

