/*
 * Decompiled with CFR 0.152.
 */
package mapy;

import graphics.ProgressBar;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import mapy.BadKeyException;
import mapy.Commands;
import mapy.Key;
import mapy.MapBlock;
import mapy.Mapy;
import util.Data;

public class Maps
extends Canvas
implements Runnable {
    private String error;
    private String operation;
    private String lid;
    private CommandListener cmdls;
    private long coordinate_x;
    private long coordinate_y;
    private int scale_level;
    private Key key;
    private MapBlock result;
    private int img_width;
    private int img_height;
    private boolean exits;
    private String response_possibilities;
    private ProgressBar progress;
    private Font font;
    private String c1;
    private String c2;
    private String c3;

    public Maps(Key key, int img_width, int img_height) {
        this.key = key;
        this.response_possibilities = "";
        this.img_width = img_width;
        this.img_height = img_height;
        this.font = Font.getFont((int)0, (int)1, (int)0);
        this.progress = new ProgressBar(this.getWidth() / 8, this.getHeight() / 2 + 2 * this.font.getHeight(), 3 * this.getWidth() / 4, this.getHeight() / 6);
        this.addCommand(Commands.cancel);
        this.exits = false;
    }

    public void setCommandListener(CommandListener cmdls) {
        this.cmdls = cmdls;
        super.setCommandListener(cmdls);
    }

    public MapBlock getMapBlock() {
        return this.result;
    }

    public void getMap(long x, long y, int scale_level, String operation, String lid) {
        this.exits = false;
        this.coordinate_x = x;
        this.coordinate_y = y;
        this.lid = lid;
        this.operation = operation;
        this.scale_level = scale_level;
        this.progress.reset();
        this.c1 = "Prob\u00edh\u00e1";
        this.c2 = "inicializace";
        this.c3 = "p\u0159ipojen\u00ed";
        this.repaint();
        Thread t = new Thread(this);
        t.start();
    }

    public void exit() {
        this.exits = true;
        this.c1 = "Prob\u00edh\u00e1";
        this.c2 = "ru\u0161en\u00ed komunikace";
        this.c3 = "komunikace";
        this.repaint();
    }

    public boolean canceled() {
        return this.exits;
    }

    public void working() {
        if (this.progress.working()) {
            this.repaint();
        }
    }

    public String possibilities() {
        return this.response_possibilities;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String target_url = "";
        HttpConnection con = null;
        InputStream is = null;
        try {
            target_url = "http://mapy.mobilfiesta.cz/jport2-1.php?job=render&key=" + this.key.getKey();
            target_url = target_url + "&x=" + this.coordinate_x + "&y=" + this.coordinate_y + "&ox=" + this.img_width + "&oy=" + this.img_height + "&scale=" + this.scale_level;
            target_url = target_url + "&operation=" + this.operation + "&lid=" + this.lid;
            if (this.exits) {
                throw new IOException();
            }
            this.c1 = "Stahuji mapu,";
            this.c2 = "pros\u00edm, \u010dekejte...";
            this.c3 = "";
            this.repaint();
            con = (HttpConnection)Connector.open((String)target_url);
            if (con == null) {
                throw new IOException("HTTP error: cannot establish connection");
            }
            this.progress.setLength((int)con.getLength() + 1);
            this.progress.start();
            this.repaint();
            int rc = con.getResponseCode();
            if (rc != 200) {
                throw new IOException("HTTP response code: " + rc);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            is = con.openInputStream();
            int nl = 0;
            int ch = is.read();
            while (!(ch == -1 || this.exits && nl > 2)) {
                baos.write(ch);
                if (ch == 10) {
                    ++nl;
                }
                this.working();
                ch = is.read();
            }
            byte[] dat = baos.toByteArray();
            if (is != null) {
                is.close();
            }
            is = null;
            if (con != null) {
                con.close();
            }
            con = null;
            is = new ByteArrayInputStream(dat);
            dat = null;
            if (is == null) {
                throw new IOException("HTTP error: cannot open InputStream");
            }
            String err = Data.getLine(is);
            Mapy.parseError(err);
            err = null;
            this.key.setKey(Data.getLine(is));
            if (this.exits) {
                throw new Exception();
            }
            this.scale_level = Data.getLengthOfBlock(is);
            int scale = Data.getLengthOfBlock(is);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (this.exits) {
                throw new Exception();
            }
            while (true) {
                int ch2;
                if ((ch2 = is.read()) == -1) {
                    if (is != null) {
                        is.close();
                    }
                    is = null;
                    this.result = new MapBlock(bos.toByteArray(), this.coordinate_x, this.coordinate_y, this.scale_level, scale);
                    if (this.exits) {
                        throw new Exception();
                    }
                    this.cmdls.commandAction(Commands.update_data, (Displayable)this);
                    break;
                }
                bos.write((byte)baos);
            }
        }
        catch (BadKeyException e) {
            this.response_possibilities = e.getResponse();
            this.cmdls.commandAction(Commands.bad_key, (Displayable)this);
        }
        catch (SecurityException se) {
            this.error = "Operace nebyla povolena.";
            this.cmdls.commandAction(Commands.error, (Displayable)this);
        }
        catch (OutOfMemoryError e) {
            this.cmdls.commandAction(Commands.full_memory, (Displayable)this);
        }
        catch (Throwable e) {
            this.error = this.exits ? "Operace zru\u0161ena u\u017eivatelem." : "Nastala chyba p\u0159i komunikaci se serverem.";
            this.cmdls.commandAction(Commands.error, (Displayable)this);
        }
        try {
            is.close();
            con.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.progress.reset();
        this.repaint();
    }

    public String getError() {
        return this.error;
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.setFont(Font.getFont((int)0, (int)1, (int)0));
        this.progress.paint(g);
        g.drawString(this.c1, this.getWidth() / 2, this.getHeight() / 2 - 1 * this.font.getHeight() / 2, 65);
        g.drawString(this.c2, this.getWidth() / 2, this.getHeight() / 2 + 1 * this.font.getHeight() / 2, 65);
    }
}

