/*
 * Decompiled with CFR 0.152.
 */
package mapy;

import graphics.GList;
import graphics.SplashScreen;
import graphics.TextDialog;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import mapy.BadKey;
import mapy.BadKeyException;
import mapy.Commands;
import mapy.Key;
import mapy.Location;
import mapy.Locations;
import mapy.MapHandler;
import mapy.MapView;
import util.Data;
import util.Event;
import util.EventHandler;
import util.News;
import util.UpdateNews;

public class Mapy
extends MIDlet
implements CommandListener,
Runnable,
EventHandler {
    public static final String app_name = "Mapy";
    private final String[] menu_items = new String[]{"Hledat ulici (obec)", "Ulo\u017een\u00e9 lokace", "Novinky", "O aplikaci"};
    private final String menu_title;
    public static final String baseURL = "http://mapy.mobilfiesta.cz/jport2-1.php?";
    private Display display = Display.getDisplay((MIDlet)this);
    private MapView map_view;
    private GList menu;
    private GList news;
    private GList locs_menu;
    private GList about;
    private GList saved_maps;
    private Form parameters_request;
    private TextField key_request;
    private TextField city_request;
    private String errors = "";
    private Key key;
    private TextDialog company;
    private TextDialog help;
    private TextDialog error;
    private MapHandler map_handler;
    private Displayable next_screen;
    private Vector locations;
    private Vector saved_locs;
    private BadKey bad_key;
    private Image backimg;
    private Vector app_news;
    private Locations locations_data;
    private boolean news_aktualized;
    private boolean news_viewed;
    private boolean asked_for_view;
    private UpdateNews news_data;
    private TextDialog confirm_update;
    private TextDialog confirm_view;
    private TextDialog too_many_locations;
    private String last_key;
    private String last_city;
    private String job;
    private Location toLoad;
    private SplashScreen sp;

    public Mapy() {
        this.menu_title = "Mapy v hrsti";
        try {
            this.backimg = Image.createImage((String)"/mapa1.jpg");
        }
        catch (Exception e) {
            this.backimg = null;
        }
        this.sp = new SplashScreen(this.backimg, "Prob\u00edh\u00e1 inicializace\naplikace");
        this.sp.progressBar().setLength(10);
        this.sp.working();
        this.display.setCurrent((Displayable)this.sp);
    }

    public void startApp() {
        this.job = "init";
        Thread t = new Thread(this);
        t.start();
    }

    public void init() {
        String h;
        this.news_aktualized = false;
        this.key = new Key();
        this.parameters_request = new Form("Hledej");
        this.key_request = new TextField("Hledan\u00e1 ulice (objekt)", "", 35, 0);
        this.city_request = new TextField("Obec (nepovinn\u00e9)", "", 35, 0);
        this.parameters_request.append((Item)this.key_request);
        this.parameters_request.append((Item)this.city_request);
        this.parameters_request.addCommand(Commands.find);
        this.parameters_request.addCommand(Commands.back);
        this.parameters_request.setCommandListener((CommandListener)this);
        this.parameters_request.setCommandListener((CommandListener)this);
        this.sp.working();
        this.bad_key = new BadKey(this.display, this.key, this.backimg);
        this.news_data = new UpdateNews(app_name);
        this.news_data.setCommandListener(this);
        this.sp.working();
        this.app_news = News.getNews();
        this.news_viewed = News.getViewed();
        this.asked_for_view = true;
        this.locations_data = new Locations(this.key);
        this.locations_data.setCommandListener(this);
        this.sp.working();
        this.about = new GList("O aplikaci Java Mapy", this.backimg, Font.getFont((int)0, (int)1, (int)0));
        this.about.append("N\u00e1pov\u011bda");
        this.about.append("O slu\u017eb\u011b");
        this.about.addCommand(Commands.select);
        this.about.addCommand(Commands.back);
        this.about.setCommandListener(this);
        this.about.repaint();
        this.sp.working();
        try {
            h = Data.get_content("/about.txt");
        }
        catch (Exception e) {
            h = "Chyba p\u0159i p\u0159\u00edstupu k souboru.";
        }
        this.sp.working();
        this.company = new TextDialog(h, Font.getFont((int)0, (int)0, (int)8), this.backimg, Commands.back);
        this.company.addCommand(Commands.back);
        this.company.setCommandListener(this);
        this.confirm_update = new TextDialog("Moment\u00e1ln\u011b nejsou st\u00e1hnuty \u017e\u00e1dn\u00e9 novinky. P\u0159ejete si je aktualizovat?", Font.getFont((int)0, (int)1, (int)0), this.backimg, Commands.yes);
        this.confirm_update.addCommand(Commands.yes);
        this.confirm_update.addCommand(Commands.no);
        this.confirm_update.setCommandListener(this);
        this.confirm_view = new TextDialog("Byly st\u00e1hnuty nov\u00e9 novinky. P\u0159ejete si je prohl\u00e9dnout?", Font.getFont((int)0, (int)1, (int)0), this.backimg, Commands.yes);
        this.confirm_view.addCommand(Commands.yes);
        this.confirm_view.addCommand(Commands.no);
        this.confirm_view.setCommandListener(this);
        this.sp.working();
        this.too_many_locations = new TextDialog("", Font.getFont((int)0, (int)1, (int)0), this.backimg, Commands.ok);
        this.too_many_locations.addCommand(Commands.ok);
        this.too_many_locations.addCommand(Commands.back);
        this.too_many_locations.setCommandListener(this);
        this.sp.working();
        try {
            this.map_handler = new MapHandler();
            this.map_handler.getData();
        }
        catch (Exception e) {
            this.errors = this.errors + "Chyba v p\u0159\u00edstupu k map\u00e1m \n";
        }
        this.sp.working();
        this.map_view = new MapView(this.backimg, this.display, this.key, this.map_handler);
        this.map_view.setEventHandler(this);
        this.menu = new GList("Mapy v hrsti", this.backimg, Font.getFont((int)0, (int)1, (int)0));
        this.menu.addCommand(Commands.select);
        int i = 0;
        while (i < this.menu_items.length) {
            this.menu.append(this.menu_items[i]);
            ++i;
        }
        this.menu.addCommand(Commands.exit);
        this.menu.setCommandListener(this);
        this.oldNews(this.news_viewed);
        this.sp.working();
        this.menu.repaint();
        if (!this.errors.equals("")) {
            this.display.setCurrent(new Alert("Chyba", this.errors, null, AlertType.ERROR), (Displayable)this.menu);
        } else {
            this.display.setCurrent((Displayable)this.menu);
        }
    }

    protected void updateNews() {
        this.display.setCurrent((Displayable)this.news_data);
        this.news_data.getNews(this.key.getKey());
    }

    public void displayNews() {
        this.asked_for_view = true;
        if (this.app_news.isEmpty()) {
            if (this.news_aktualized) {
                this.confirm_update.set_text("Je n\u00e1m l\u00edto, ale moment\u00e1ln\u011b nejsou dostupn\u00e9 \u017e\u00e1dn\u00e9 novinky.");
                this.confirm_update.removeCommand(Commands.yes);
                this.confirm_update.removeCommand(Commands.no);
                this.confirm_update.addCommand(Commands.back);
            } else {
                this.confirm_update.set_text("Moment\u00e1ln\u011b nejsou st\u00e1hnuty \u017e\u00e1dn\u00e9 novinky. P\u0159ejete si je aktualizovat?");
                this.confirm_update.addCommand(Commands.yes);
                this.confirm_update.addCommand(Commands.no);
                this.confirm_update.removeCommand(Commands.back);
            }
            this.display.setCurrent((Displayable)this.confirm_update);
            return;
        }
        Enumeration enu = this.app_news.elements();
        this.news_viewed = true;
        News.setViewed(this.news_viewed);
        this.oldNews(this.news_viewed);
        this.news = new GList("Novinky", this.backimg, Font.getFont((int)0, (int)1, (int)0));
        while (enu.hasMoreElements()) {
            String str = (String)enu.nextElement();
            this.news.append(News.getTitle(str));
        }
        this.news.addCommand(Commands.back);
        this.news.addCommand(Commands.aktualize);
        this.news.addCommand(Commands.read);
        this.news.setCommandListener(this);
        this.display.setCurrent((Displayable)this.news);
        this.news.repaint();
    }

    public void showString(String text, Command c, Displayable next) {
        this.error = new TextDialog("", Font.getFont((int)0, (int)1, (int)0), this.backimg, null);
        this.error.addCommand(c);
        this.error.set_fire_command(c);
        this.error.setCommandListener(this);
        this.error.set_text(text);
        this.next_screen = next;
        this.error.repaint();
        this.display.setCurrent((Displayable)this.error);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        if (this.map_handler != null) {
            this.map_handler.close();
        }
        this.notifyDestroyed();
    }

    public static void parseError(String s) throws Exception {
        char ch = s.charAt(6);
        if (ch != '0') {
            switch (ch) {
                case '1': {
                    throw new BadKeyException(s.substring(7));
                }
                case '2': {
                    throw new Exception("Chyba: nebyl zad\u00e1n dostate\u010dn\u00fd po\u010det parametru");
                }
                case '3': {
                    throw new Exception("Nezn\u00e1ma chyba na serveru");
                }
            }
        }
    }

    public String removeSpaces(String s) {
        while (s.length() > 0) {
            if (s.charAt(0) != ' ') break;
            s = s.substring(1);
        }
        while (s.length() > 0) {
            if (s.charAt(s.length() - 1) != ' ') break;
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void oldNews(boolean n) {
        if (!n) {
            this.menu.setItem(this.menu_items[2] + " (!)", 2);
        } else {
            this.menu.setItem(this.menu_items[2], 2);
        }
    }

    public void new_news(Vector newz) {
        if (newz != null && News.compareNews(newz, this.app_news)) {
            this.app_news = newz;
            this.news_viewed = false;
            this.asked_for_view = false;
            News.setViewed(this.news_viewed);
            this.oldNews(this.news_viewed);
            try {
                News.writeNews(this.app_news);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateData(Displayable disp) {
        if (disp == this.locations_data) {
            this.locations = this.locations_data.result();
            if (this.locations == null) {
                return;
            }
            if (this.locations.isEmpty()) {
                this.display.setCurrent(new Alert("Chyba", "Litujeme, pro zadan\u00e9 \u00fadaje se nena\u0161el \u017e\u00e1dn\u00fd z\u00e1znam", null, AlertType.INFO), (Displayable)this.parameters_request);
                return;
            }
            this.locs_menu = new GList("V\u00fdb\u011br lokace", null, Font.getFont((int)0, (int)1, (int)8));
            this.locs_menu.addCommand(Commands.choose);
            this.locs_menu.addCommand(Commands.back);
            this.locs_menu.addCommand(Commands.details);
            this.locs_menu.setCommandListener(this);
            Enumeration enu = this.locations.elements();
            int f = 0;
            while (enu.hasMoreElements()) {
                ++f;
                Location lc = (Location)enu.nextElement();
                this.locs_menu.append(lc.short_desc);
            }
            int found = this.locations_data.locationsFound();
            this.last_key = this.key_request.getString();
            this.last_city = this.city_request.getString();
            if (f == found) {
                this.display.setCurrent((Displayable)this.locs_menu);
            } else {
                this.too_many_locations.set_text("Bylo nalezeno " + found + " lokac\u00ed, zobrazen\u00fdch " + this.locations.size() + " z " + found + ". Pro nezobrazen\u00e9 lokace bl\u00ed\u017ee specifikujte hledan\u00fd v\u00fdraz.");
                this.display.setCurrent((Displayable)this.too_many_locations);
            }
            this.new_news(this.locations_data.newsResult());
        }
        if (disp == this.news_data) {
            this.new_news(this.news_data.result());
            this.displayNews();
        }
    }

    public void displaySavedLocations() {
        this.saved_locs = this.map_handler.getLocs();
        if (this.saved_locs.isEmpty()) {
            this.display.setCurrent(new Alert("Pr\u00e1zdn\u00e9", "Zat\u00edm nebyly ulo\u017eeny \u017e\u00e1dn\u00e9 mapy", null, AlertType.INFO), (Displayable)this.menu);
            return;
        }
        this.saved_maps = new GList("Ulo\u017een\u00e9 lokace", this.backimg, Font.getFont((int)0, (int)1, (int)8));
        this.saved_maps.setCommandListener(this);
        this.saved_maps.addCommand(Commands.load);
        this.saved_maps.addCommand(Commands.delete);
        this.saved_maps.addCommand(Commands.back);
        int i = 0;
        while (i < this.saved_locs.size()) {
            this.saved_maps.append(((Location)this.saved_locs.elementAt((int)i)).short_desc);
            ++i;
        }
        this.display.setCurrent((Displayable)this.saved_maps);
    }

    public static String generateLid() {
        return (System.currentTimeMillis() / 100L - 11037600000L) % 3153600000L + "";
    }

    public void onSelectCommand(Displayable s) {
        if (s == this.menu) {
            int index = this.menu.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.key_request.setString("");
                    this.city_request.setString("");
                    this.display.setCurrent((Displayable)this.parameters_request);
                    break;
                }
                case 1: {
                    this.displaySavedLocations();
                    break;
                }
                case 2: {
                    this.displayNews();
                    break;
                }
                case 3: {
                    this.display.setCurrent((Displayable)this.about);
                    this.about.repaint();
                }
            }
            return;
        }
        if (s == this.locs_menu) {
            int index = this.locs_menu.getSelectedIndex();
            if (index >= 0) {
                this.map_view.setBackscreen((Displayable)this.locs_menu);
                this.map_view.setLocation((Location)this.locations.elementAt(index));
            }
            return;
        }
        if (s == this.saved_maps) {
            int index = this.saved_maps.getSelectedIndex();
            if (index >= 0) {
                this.display.setCurrent((Displayable)new SplashScreen(this.backimg, "Prob\u00edh\u00e1 \u010dten\u00ed\nmapy"));
                this.map_view.setBackscreen((Displayable)this.saved_maps);
                this.toLoad = (Location)this.saved_locs.elementAt(index);
                this.job = "load map";
                Thread t = new Thread(this);
                t.start();
            }
            return;
        }
        if (s == this.news) {
            int index = this.news.getSelectedIndex();
            if (index >= 0) {
                String str = (String)this.app_news.elementAt(index);
                this.showString(News.getText(str), Commands.back, (Displayable)this.news);
            }
            return;
        }
        if (s == this.about) {
            int index = this.about.getSelectedIndex();
            switch (index) {
                case 0: {
                    if (this.help != null) {
                        this.display.setCurrent((Displayable)this.help);
                        break;
                    }
                    this.display.setCurrent((Displayable)new SplashScreen(this.backimg, "Vy\u010dkejte pros\u00edm,\nprob\u00edh\u00e1 \u010dten\u00ed n\u00e1pov\u011bdy.\nTato operace m\u016f\u017ee\ntrvat a\u017e n\u011bkolik sekund."));
                    this.job = "load help";
                    Thread t = new Thread(this);
                    t.start();
                    break;
                }
                case 1: {
                    this.display.setCurrent((Displayable)this.company);
                }
            }
            return;
        }
    }

    public void onBackCommand(Displayable disp) {
        if (disp == this.locs_menu || disp == this.too_many_locations) {
            this.display.setCurrent((Displayable)this.parameters_request);
            return;
        }
        if (disp == this.parameters_request || disp == this.news) {
            if (this.asked_for_view) {
                this.display.setCurrent((Displayable)this.menu);
            } else {
                this.display.setCurrent((Displayable)this.confirm_view);
                this.asked_for_view = true;
            }
            return;
        }
        if (disp == this.saved_maps) {
            this.display.setCurrent((Displayable)this.menu);
            return;
        }
        if (disp == this.about) {
            this.display.setCurrent((Displayable)this.menu);
            return;
        }
        if (disp == this.company || disp == this.help) {
            this.display.setCurrent((Displayable)this.about);
            return;
        }
    }

    public void onCancelCommand(Displayable disp) {
        if (disp == this.locations_data) {
            this.locations_data.exit();
        }
    }

    public void onFindCommand(Displayable disp) {
        String k = this.key_request.getString();
        String c = this.city_request.getString();
        if (k.equals(this.last_key) && c.equals(this.last_city)) {
            this.display.setCurrent((Displayable)this.locs_menu);
            return;
        }
        if (k.length() < 1 && c.length() > 0) {
            k = c;
            c = "";
        }
        k = this.removeSpaces(k);
        c = this.removeSpaces(c);
        if (k.length() < 2) {
            this.display.setCurrent(new Alert("Kr\u00e1tk\u00fd parametr", "Parametr \"Hledan\u00e1 ulice\" je p\u0159\u00edli\u0161 kr\u00e1tk\u00fd.", null, AlertType.INFO), (Displayable)this.parameters_request);
            return;
        }
        this.locations = null;
        this.display.setCurrent((Displayable)this.locations_data);
        this.locations_data.getLocations(k, c, this.news_aktualized);
        this.news_aktualized = true;
    }

    public void onAktualizeCommand(Displayable disp) {
        this.updateNews();
    }

    public void onDetailsCommand(Displayable disp) {
        if (disp == this.locs_menu) {
            this.showString(((Location)this.locations.elementAt((int)this.locs_menu.getSelectedIndex())).description, Commands.back, (Displayable)this.locs_menu);
        }
    }

    public void onErrorCommand(Displayable disp) {
        if (disp == this.locations_data) {
            if (this.locations_data.canceled()) {
                this.display.setCurrent(new Alert("Zru\u0161eno", this.locations_data.getError(), null, AlertType.INFO), (Displayable)this.parameters_request);
            } else {
                this.showString(this.locations_data.getError(), Commands.ok, (Displayable)this.parameters_request);
            }
        } else if (disp == this.news_data) {
            this.showString(this.news_data.getError(), Commands.ok, (Displayable)this.news);
        }
    }

    public void onBadKeyCommand(Displayable disp) {
        if (disp == this.locations_data) {
            this.new_news(this.locations_data.newsResult());
            this.bad_key.badKey((Displayable)this.parameters_request, this.locations_data.possibilities());
        }
    }

    public void onYesCommand(Displayable disp) {
        if (disp == this.confirm_update) {
            this.onAktualizeCommand((Displayable)this.menu);
        }
        if (disp == this.confirm_view) {
            this.displayNews();
        }
    }

    public void onNoCommand(Displayable disp) {
        this.display.setCurrent((Displayable)this.menu);
    }

    public void onOkCommand(Displayable disp) {
        if (disp == this.too_many_locations) {
            this.display.setCurrent((Displayable)this.locs_menu);
        }
    }

    public void onDeleteCommand(Displayable disp) {
        this.display.setCurrent((Displayable)new SplashScreen(this.backimg, "Prob\u00edh\u00e1 maz\u00e1n\u00ed\nmapy"));
        this.job = "delete map";
        Thread t = new Thread(this);
        t.start();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.error) {
            this.display.setCurrent(this.next_screen);
            return;
        }
        if (command == Commands.yes) {
            this.onYesCommand(displayable);
        }
        if (command == Commands.no) {
            this.onNoCommand(displayable);
        }
        if (command == Commands.delete) {
            this.onDeleteCommand(displayable);
        }
        if (command.getCommandType() == 7) {
            this.destroyApp(false);
        }
        if (command == Commands.update_data || command == UpdateNews.update_data) {
            this.updateData(displayable);
        }
        if (command == Commands.cancel) {
            this.onCancelCommand(displayable);
        }
        if (command == Commands.error || command == UpdateNews.error) {
            this.onErrorCommand(displayable);
        }
        if (command == Commands.find) {
            this.onFindCommand(displayable);
        }
        if (command == List.SELECT_COMMAND || command == Commands.select || command == Commands.choose || command == Commands.read) {
            this.onSelectCommand(displayable);
        }
        if (command == Commands.load) {
            this.onSelectCommand(displayable);
        }
        if (command == Commands.bad_key) {
            this.onBadKeyCommand(displayable);
        }
        if (command.getCommandType() == 2) {
            this.onBackCommand(displayable);
        }
        if (command == Commands.details) {
            this.onDetailsCommand(displayable);
        }
        if (command == Commands.aktualize) {
            this.onAktualizeCommand(displayable);
        }
        if (command == Commands.ok) {
            this.onOkCommand(displayable);
        }
    }

    public void run() {
        if (this.job.equals("init")) {
            this.init();
            return;
        }
        if (this.job.equals("delete map")) {
            try {
                this.map_handler.delLoc(this.saved_maps.getSelectedIndex());
            }
            catch (Exception e) {
                this.showString("Vyskytla se chyba p\u0159i maz\u00e1n\u00ed", Commands.ok, (Displayable)this.saved_maps);
            }
            this.displaySavedLocations();
            return;
        }
        if (this.job.equals("load map")) {
            this.map_view.loadMap(this.toLoad);
            return;
        }
        if (this.job.equals("load help")) {
            String h;
            try {
                h = Data.get_content("/napoveda.txt");
            }
            catch (Exception e) {
                h = "Chyba p\u0159i p\u0159\u00edstupu k souboru.";
            }
            this.help = new TextDialog(h, Font.getFont((int)0, (int)0, (int)8), this.backimg, Commands.back);
            this.help.addCommand(Commands.back);
            this.help.setCommandListener(this);
            this.display.setCurrent((Displayable)this.help);
        }
    }

    public void handle(Event event, Object object) {
        if (event == EventHandler.BACK && object == this.map_view) {
            if (this.map_view.getBackscreen() == this.locs_menu) {
                this.display.setCurrent((Displayable)this.locs_menu);
            } else {
                this.displaySavedLocations();
            }
        }
    }

    static {
        app_name = app_name;
        baseURL = baseURL;
    }
}

