/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.rms.RecordStore;
import util.Data;
import util.URLUTF8Encoder;
import util.Utf8;

public class News {
    private static final String newsURL = "http://mapy.mobilfiesta.cz/news.php?app=";

    public static String getTitle(String str) {
        return str.substring(0, str.indexOf("\n"));
    }

    public static String getText(String str) {
        return str.substring(str.indexOf("\n") + 1);
    }

    public static boolean compareNews(Vector n1, Vector n2) {
        if (n1.size() != n2.size()) {
            return true;
        }
        Enumeration enu1 = n1.elements();
        Enumeration enu2 = n2.elements();
        while (enu1.hasMoreElements()) {
            if (((String)enu1.nextElement()).equals((String)enu2.nextElement())) continue;
            return true;
        }
        return false;
    }

    public static Vector updateNews(String app) throws Exception {
        return News.updateNews(app, "");
    }

    /*
     * WARNING - void declaration
     */
    public static Vector updateNews(String app, String key) throws Exception {
        HttpConnection con;
        Vector<String> app_news = new Vector<String>();
        String response = "";
        String targetURL = newsURL + URLUTF8Encoder.encode(app);
        if (key.length() > 0) {
            targetURL = targetURL + "&key=" + key;
        }
        if ((con = (HttpConnection)Connector.open((String)targetURL)) != null) {
            int ch;
            int rc = con.getResponseCode();
            if (rc != 200) {
                throw new IOException("HTTP response code: " + rc);
            }
            InputStream is = con.openInputStream();
            if (is == null) {
                throw new IOException("HTTP error: cannot open InputStream");
            }
            String pnews = "";
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                void var14_10;
                bos.write((int)var14_10);
            }
            pnews = Utf8.getString(bos.toByteArray());
            int p = 0;
            int a = 0;
            int no = 0;
            do {
                String am = "";
                ++no;
                while (pnews.charAt(p) != '\n') {
                    am = am + pnews.charAt(p);
                    if (++p >= pnews.length()) break;
                }
                try {
                    a = Integer.parseInt(am);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Bad response from server - bad numeric format - " + am);
                }
                ++p;
                if (a == 0) break;
                if (p + a <= pnews.length()) {
                    app_news.addElement(pnews.substring(p, p + a));
                }
                p += a;
            } while (a != 0);
            if (con != null) {
                con.close();
            }
        } else {
            throw new IOException("HTTP error: cannot set up network connection");
        }
        return app_news;
    }

    public static byte writeNews(Vector news) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Enumeration enu = news.elements();
        while (enu.hasMoreElements()) {
            byte[] s = Utf8.getBytes((String)enu.nextElement());
            output.write((s.length + "\n").getBytes());
            output.write(s);
        }
        byte[] news_data = output.toByteArray();
        try {
            RecordStore record_store = RecordStore.openRecordStore((String)"NEWS", (boolean)true);
            if (record_store.getNumRecords() == 0) {
                record_store.addRecord(news_data, 0, news_data.length);
            } else {
                record_store.setRecord(1, news_data, 0, news_data.length);
            }
            record_store.closeRecordStore();
        }
        catch (Exception e) {
            throw new Exception("Error writing news to the database");
        }
        return 0;
    }

    public static void setViewed(boolean b) {
        byte[] viewed_data = new byte[]{b ? (byte)0 : 1};
        try {
            RecordStore record_store = RecordStore.openRecordStore((String)"NEWS", (boolean)true);
            if (record_store.getNumRecords() == 0) {
                record_store.addRecord(viewed_data, 0, viewed_data.length);
            }
            if (record_store.getNumRecords() == 1) {
                record_store.addRecord(viewed_data, 0, viewed_data.length);
            }
            record_store.setRecord(2, viewed_data, 0, viewed_data.length);
            record_store.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean getViewed() {
        try {
            RecordStore record_store = RecordStore.openRecordStore((String)"NEWS", (boolean)true);
            byte[] viewed_data = record_store.getRecord(2);
            record_store.closeRecordStore();
            return viewed_data[0] == 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static Vector getNews() {
        Vector<String> news = new Vector<String>();
        try {
            RecordStore record_store = RecordStore.openRecordStore((String)"NEWS", (boolean)true);
            byte[] news_data = record_store.getRecord(1);
            ByteArrayInputStream inp = new ByteArrayInputStream(news_data);
            if (inp != null) {
                while (inp.available() > 0) {
                    news.addElement(Data.getNextString(inp));
                }
            }
            record_store.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
        return news;
    }

    static {
        newsURL = newsURL;
    }
}

