/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class Utf8 {
    public static String getString(byte[] bytes) {
        String string = "";
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        while (is.available() > 0) {
            int ch = 0;
            int b1 = is.read();
            if (b1 < 128) {
                ch = b1;
            } else if (b1 > 192 && b1 <= 223) {
                int b2 = is.read();
                if (b2 > 127) {
                    ch = (b1 - 192) * 64 + (b2 - 128);
                }
            } else {
                ch = 63;
            }
            string = string + (char)ch;
        }
        return string;
    }

    public static byte[] getBytes(String string) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                out.write(ch);
            } else if (ch >= '\u0080' && ch <= '\u07ff') {
                int b1 = 192 + ch / 64;
                int b2 = 128 + ch % 64;
                out.write(b1);
                out.write(b2);
            }
            ++i;
        }
        return out.toByteArray();
    }
}

